/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.util;

public abstract class TextUtils {
    private TextUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static int countLines(CharSequence content) {
        return new LineSplitter(content).countLines();
    }

    public static CharSequence selectHeadLines(CharSequence content, int lines) {
        return new LineSplitter(content).selectHeadLines(lines);
    }

    private static class LineSplitter {
        private final CharSequence content;
        protected final int contentEnd;
        protected int contentPos;
        protected String lastLineDelimiter = null;
        private static final String DELIMITER_WINDOWS = "\r\n";
        private static final String DELIMITER_UNIX = "\n";
        private static final String DELIMITER_MAC = "\r";

        public LineSplitter(CharSequence content) {
            this.content = content;
            this.contentEnd = content.length();
        }

        public CharSequence selectHeadLines(int lines) {
            this.contentPos = 0;
            while (lines > 0 && this.contentPos < this.contentEnd) {
                this.findEndOfLine();
                --lines;
            }
            return this.content.subSequence(0, this.contentPos);
        }

        public int countLines() {
            this.contentPos = 0;
            int count = 0;
            while (this.contentPos < this.contentEnd) {
                this.findEndOfLine();
                ++count;
            }
            return count;
        }

        protected final int findEndOfLine() {
            while (this.contentPos < this.contentEnd) {
                char charAt1 = this.content.charAt(this.contentPos);
                if (charAt1 == '\r') {
                    int endLine = this.contentPos++;
                    if (this.contentPos < this.contentEnd && this.content.charAt(this.contentPos) == '\n') {
                        ++this.contentPos;
                        this.lastLineDelimiter = DELIMITER_WINDOWS;
                    } else {
                        this.lastLineDelimiter = DELIMITER_MAC;
                    }
                    return endLine;
                }
                if (charAt1 == '\n') {
                    int endLine = this.contentPos++;
                    this.lastLineDelimiter = DELIMITER_UNIX;
                    return endLine;
                }
                ++this.contentPos;
            }
            this.lastLineDelimiter = null;
            return this.contentPos;
        }
    }
}

